const mongoose = require("mongoose");

const employeeSchema = new mongoose.Schema({
  email: {
    type: String,
    required: true,
  },
  discountValue: {
    type: String,
    required: true,
  },
  discountType: {
    type: String,
    required: true,
  },
  userCapTotal: {
    type: Number,
    require: true,
  },
  userCapRemain: {
    type: Number,
    require: true,
  },
  allocatedMonth: {
    type: Date,
    default: Date.now,
  },
  //shopify store to which employee is registed
  employeeAssociation: {
    type: String,
    default: null,
  },
  discountInfo: {
    format: {
      type: String,
      default: "Order",
    },
    collectionIds: {
      type: Array, // <-- now an array of strings
      default: [],
    },
  },
  //organization domain in email
  employeeOrganization: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "organizations", // reference to organization
    default: null,
  },
});

module.exports = mongoose.model("employees_global", employeeSchema);
